[WARNING]
WARNING: DO NOT EDIT THIS FILE DIRECTLY!
Use only E-Studio to edit this file.
Editing of this file from any other means is not supported
and may corrupt the experiment design specification.
Technical support will not be able to address any issue in
regards to this file format.

[Experiment]
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=75
_VersionPersist=6
Root="RootProc"
Author="Paul Groot (Vrije Universiteit)"
Abstract="This script implements a reading test where only a few words \r\nare readable, and the rest of the text is masked. The arrow \r\nkey's can be used to walk through the text. A custom \r\noutput file is created with detailed timing information.\r\n\r\naka Poor Man's Eye Tracker\r\n"
Notes=""
Creation=1043226552

[Device0]
_VersionPersist=1
OpenDevice=1
Width=800
Height=600
Bpp=32
Name="Display"
Class="Display"

[Device1]
_VersionPersist=1
OpenDevice=0
Channels=2
Samples=22050
Bps=16
Name="Sound"
Class="Sound"

[Device2]
_VersionPersist=1
OpenDevice=1
CollectionMode=1
EmulateDeviceName=""
CapsLock=0
NumLock=1
Name="Keyboard"
Class="Keyboard"

[Device3]
_VersionPersist=1
OpenDevice=1
CollectionMode=1
EmulateDeviceName=""
OpenMode=0
ShowCursor=0
Name="Mouse"
Class="Mouse"

[DataFile]
WarnBeforeOverwrite=0
WarnIfConvertFailed=0
RemoveERecoveryFile=0
ReceiveFeedbackDuringDataFileConversion=0
LogLevel(2).Name="Block"
LogLevel(3).Name="Trial"
LogLevel(4).Name="SubTrial"
LogLevel(5).Name="LogLevel5"
LogLevel(6).Name="LogLevel6"
LogLevel(7).Name="LogLevel7"
LogLevel(8).Name="LogLevel8"
LogLevel(9).Name="LogLevel9"
LogLevel(10).Name="LogLevel10"

[StartupInfo]
DisplaySummary=1
UseDefaults=0

[StartupInfo1]
Name="Subject"
Prompt="Please enter the Subject Number (1-32767, 0=No Data Logging):"
DataType=0
Enabled=1
PromptEnabled=1
Default="1"
Min=0
Max=32767
PrivateFlags=268435477
PrivateInfo=1

[StartupInfo2]
Name="Session"
Prompt="Please enter the Session Number (1-32767):"
DataType=0
Enabled=1
PromptEnabled=1
Default="1"
Min=1
Max=32767
PrivateFlags=268435477
PrivateInfo=1

[StartupInfo3]
Name="Group"
Prompt="Please enter Subject's Group (0-32767):"
DataType=0
Enabled=0
PromptEnabled=0
Default="1"
Min=0
Max=32767

[StartupInfo4]
Name="Name"
Prompt="Please enter Subject's Name:"
DataType=1
Enabled=0
PromptEnabled=0
Default=""
MaxLength=255

[StartupInfo5]
Name="Age"
Prompt="Please enter Subject's Age (0-150):"
DataType=0
Enabled=0
PromptEnabled=0
Default="0"
Min=0
Max=150

[StartupInfo6]
Name="Sex"
Prompt="Please enter Subject's Sex:"
DataType=2
Enabled=0
PromptEnabled=0
Default="male"
Choice(1).Value="male"
Choice(2).Value="female"

[StartupInfo7]
Name="Handedness"
Prompt="Enter Subject's Handedness:"
DataType=2
Enabled=0
PromptEnabled=0
Default="left"
Choice(1).Value="left"
Choice(2).Value="right"

[StartupInfo8]
Name="ResearcherID"
Prompt="Please enter Researcher's ID:"
DataType=0
Enabled=0
PromptEnabled=0
Default="1"
Min=0
Max=32767

[StartupInfo9]
Name="Filename"
Prompt="Type the name of the text file"
DataType=1
Enabled=1
PromptEnabled=0
Default="example.txt"
MaxLength=255

[StartupInfo10]
Name="WindowSize"
Prompt="Enter the number of readable words"
DataType=0
Enabled=1
PromptEnabled=1
Default="2"
Min=1
Max=5

[Object0]
_Version=65536
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
_ItemList="StartSession;InitExp;TrialList;CloseExp"
_VersionPersist=1
FlowLines(0).Count=4
FlowLines(0).FlowItem(0).Name="StartSession"
FlowLines(0).FlowItem(1).Name="InitExp"
FlowLines(0).FlowItem(2).Name="TrialList"
FlowLines(0).FlowItem(3).Name="CloseExp"
LogData=1
Name="SessionProc"
TypeName="Procedure"
Tag=""
Notes=""

[Object1]
_Version=65536
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
Logging("TextColor").Log=-1
Logging("XColor").Log=-1
Logging("FontSize").Log=-1
_ItemList="SessionProc"
_VersionPersist=1
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
Order=0
OrderBy=0
ResetEveryRun=0
HideLevelsWithZeroWeight=0
CycleDef=0
CycleValueSamples=0
CycleValueCondition=""
ExitDef=0
ExitValueCycles=1
ExitValueSamples=1
ExitValueSeconds=0
ExitValueCondition=""
LoadMethod=0
Filename=""
UserAttributes=3
Attributes("Weight").DefaultValue="1"
Attributes("Weight").Visible=1
Attributes("Weight").Width=75
Attributes("Weight").OrderIndex=0
Attributes("Nested").DefaultValue=""
Attributes("Nested").Visible=1
Attributes("Nested").Width=75
Attributes("Nested").OrderIndex=1
Attributes("Procedure").DefaultValue="SessionProc"
Attributes("Procedure").Visible=1
Attributes("Procedure").Width=93
Attributes("Procedure").OrderIndex=2
Attributes(1).Name="TextColor"
Attributes(1).DefaultValue="black"
Attributes(1).VarType=8
Attributes(1).VarTypeInternal=8
Attributes(1).Visible=1
Attributes(1).Width=75
Attributes(2).Name="XColor"
Attributes(2).DefaultValue="silver"
Attributes(2).VarType=8
Attributes(2).VarTypeInternal=8
Attributes(2).Visible=1
Attributes(2).Width=75
Attributes(3).Name="FontSize"
Attributes(3).DefaultValue="16"
Attributes(3).VarType=8
Attributes(3).VarTypeInternal=8
Attributes(3).Visible=1
Attributes(3).Width=75
Levels=1
Levels(1).ValueString="1\t\tSessionProc\tblack\tsilver\t16\t"
Name="BlockList"
TypeName="List"
Tag=""
Notes=""

[Object2]
_Version=65536
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
Logging("OnsetDelay").Log=0
Logging("OnsetTime").Log=0
Logging("DurationError").Log=0
Logging("PreRelease").Log=0
Logging("Duration").Log=0
Logging("StartTime").Log=0
Logging("OffsetTime").Log=0
Logging("FinishTime").Log=0
Logging("TimingMode").Log=0
Logging("CustomOnsetTime").Log=0
Logging("CustomOffsetTime").Log=0
Logging("ActionDelay").Log=0
Logging("ActionTime").Log=0
Logging("TargetOffsetTime").Log=0
Logging("TargetOnsetTime").Log=0
Logging("OffsetDelay").Log=0
Logging("RTTime").Log=0
Logging("ACC").Log=0
Logging("RT").Log=0
Logging("RESP").Log=0
Logging("CRESP").Log=0
Logging("Tag").Log=0
Input(0)=!Data0
_VersionPersist=2
ActiveState="Default"
States.Count=1
States(1).Name="Default"
States("Default").X="center"
States("Default").Y="center"
States("Default").Width="100%"
States("Default").Height="100%"
States("Default").XAlign="center"
States("Default").YAlign="center"
States("Default").BackColor="white"
States("Default").BackStyle="transparent"
States("Default").BorderColor="black"
States("Default").BorderWidth="0"
States("Default").ClearAfter="No"
States("Default").Enabled="Yes"
States("Default").ChildCount=0
Duration="-1"
JumpLabel=""
TimingMode=0
PreRelease="0"
OnsetSync=1
OffsetSync=0
Name="TextSlide"
TypeName="Slide"
Tag=""
Notes=""

[Data0]
DeviceName="Keyboard"
DeviceClass="Keyboard"
AllowableInput="{LEFTARROW}{RIGHTARROW}{UPARROW}{DOWNARROW}{ESCAPE}"
CorrectInput=""
TimeLimit=""
MaxCount="1"
InputAction=1
SyncOwnerDuration=1
Enabled=1
FlushInputBuffer="Yes"
TerminationInput=""
UserTag=""
ResponseMode="All"
ProcessBackspace="Yes"

[Object3]
_Version=131072
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
_VersionPersist=1
Code="Dim cnvs As Canvas\t\t\t\t\t' canvas object to draw on\nDim i as integer\n\n\nSet cnvs = Display.Canvas\t\t\t' initialize canvas object\n\n\n'cnvs.BackStyle = \"transparent\"\nfor i=1 to nWindows\n\tif windows(i).page=iCurrentPage then\n\t\tif i=iCurrentWindow then\n\t\t\tcnvs.TextColor = CColor(txtColor)\n\t\t\tcnvs.Text windows(i).x, windows(i).y, windows(i).txt\n\t\telseif i=iPrevWindow or bRefreshAll then\n\t\t\tdim s as string\n\t\t\tdim j as integer\n'\t\t\tdim pos as integer\n\t\t\ts = String$(Len(windows(i).txt),\"x\")\n'\t\t\tpos = 1\n'\t\t\tdo while pos>0\n'\t\t\t\tpos = Instr(pos, windows(i).txt, \" \")\n'\t\t\t\tif pos>0 then s = Left$(s,pos-1) & \" \" & Mid$(s,pos+1)\n'\t\t\tloop\n\t\t\tfor j=1 to Len(windows(i).txt)\n\t\t\t\tif Mid$(windows(i).txt,j,1)=\" \" then s = Left$(s,j-1) & \" \" & Mid$(s,j+1)\n\t\t\tnext\n\t\t\tcnvs.TextColor = CColor(xColor)\n\t\t\tcnvs.Text windows(i).x, windows(i).y, s\n\t\tend if\n\tend if\nnext\n\nbRefreshAll = false"
Name="PrepareText"
TypeName="InLine"
Tag=""
Notes=""

[Object4]
_Version=131072
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
_VersionPersist=1
Code="dim iNextWindow as integer\ndim prevDist as integer\ndim iOtherLine as integer\ndim dist as integer\n\niNextWindow = iCurrentWindow\n\n\nSelect Case TextSlide.RESP\nCase \"{LEFTARROW}\"\n\tif iCurrentWindow>1 then iNextWindow = iCurrentWindow-1\n\tiBrowseAnchorX = 0\n\nCase \"{RIGHTARROW}\"\n\tif iCurrentWindow<nWindows then iNextWindow = iCurrentWindow+1\n\tiBrowseAnchorX = 0\n\nCase \"{UPARROW}\"\n\tprevDist = Display.XRes ' just a silly but large value\n\tiOtherLine = 0\n\tif iBrowseAnchorX = 0 then iBrowseAnchorX = windows(iCurrentWindow).x + windows(iCurrentWindow).w/2 ' start new up/down sequence\n\tfor i=iCurrentWindow-1 to 1 step -1\n\t\tif windows(i).linenr < windows(iCurrentWindow).linenr then\n\t\t\tif iOtherLine = 0 then\n\t\t\t\tiOtherLine = windows(i).linenr ' this is the number of the previous line\n\t\t\telseif windows(i).linenr <> iOtherLine then\n\t\t\t\texit for ' beyond previous line\n\t\t\tend if\n\t\t\tdist = abs(windows(i).x + windows(i).w/2 - iBrowseAnchorX)\n\t\t\tif (dist<prevDist) then\n\t\t\t\tprevDist = dist\n\t\t\t\tiNextWindow = i\n\t\t\tend if\n\t\tend if\n\tnext\n\nCase \"{DOWNARROW}\"\n\tprevDist = Display.XRes ' just a silly but large value\n\tiOtherLine = 0\n\tif iBrowseAnchorX = 0 then iBrowseAnchorX = windows(iCurrentWindow).x + windows(iCurrentWindow).w/2 ' start new up/down sequence\n\tfor i=iCurrentWindow+1 to nWindows\n\t\tif windows(i).linenr > windows(iCurrentWindow).linenr then\n\t\t\tif iOtherLine = 0 then\n\t\t\t\tiOtherLine = windows(i).linenr ' this is the number of the next line\n\t\t\telseif windows(i).linenr <> iOtherLine then\n\t\t\t\texit for ' beyond previous line\n\t\t\tend if\n\t\t\tdist = abs(windows(i).x + windows(i).w/2 - iBrowseAnchorX)\n\t\t\tif (dist<prevDist) then\n\t\t\t\tprevDist = dist\n\t\t\t\tiNextWindow = i\n\t\t\tend if\n\t\tend if\n\tnext\n\nCase \"{ESCAPE}\"\n'\tSetUserBreakState(1)\n\tbAbort = true\nEnd Select\n\ndim str1 as string\ndim str2 as string\nstr1 = Format(iCurrentWindow,\"@@@@@@@@\")\nstr2 = Format(TextSlide.RT,\"        @@@@@@@@\")\nif iPrevWindow<iCurrentWindow then\n\t' step forward\n\tprint #2, str1; str2; tab(34) windows(iCurrentWindow).txt\nelse\n\tprint #2, tab(9) str1; str2; tab(34) windows(iCurrentWindow).txt\nend if\n\niPrevWindow = iCurrentWindow\niCurrentWindow = iNextWindow\n\ni = windows(iCurrentWindow).page\nif i<>iCurrentPage then\n\tiCurrentPage = i\n\tcnvs.Clear\n\tbRefreshAll = true\nend if\n"
Name="NextWindow"
TypeName="InLine"
Tag=""
Notes=""

[Object5]
_Version=65536
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
_ItemList="TrialProc"
_VersionPersist=1
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
Order=0
OrderBy=0
ResetEveryRun=0
HideLevelsWithZeroWeight=0
CycleDef=0
CycleValueSamples=0
CycleValueCondition=""
ExitDef=2
ExitValueCycles=1
ExitValueSamples=1
ExitValueSeconds=3600
ExitValueCondition=""
LoadMethod=0
Filename=""
UserAttributes=0
Attributes("Weight").DefaultValue="1"
Attributes("Weight").Visible=1
Attributes("Weight").Width=75
Attributes("Weight").OrderIndex=0
Attributes("Nested").DefaultValue=""
Attributes("Nested").Visible=1
Attributes("Nested").Width=75
Attributes("Nested").OrderIndex=1
Attributes("Procedure").DefaultValue="TrialProc"
Attributes("Procedure").Visible=1
Attributes("Procedure").Width=75
Attributes("Procedure").OrderIndex=2
Levels=1
Levels(1).ValueString="1\t\tTrialProc\t"
Name="TrialList"
TypeName="List"
Tag=""
Notes=""

[Object6]
_Version=65536
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
_ItemList="PrepareText;TextSlide;NextWindow;CheckAbort"
_VersionPersist=1
FlowLines(0).Count=4
FlowLines(0).FlowItem(0).Name="PrepareText"
FlowLines(0).FlowItem(1).Name="TextSlide"
FlowLines(0).FlowItem(2).Name="NextWindow"
FlowLines(0).FlowItem(3).Name="CheckAbort"
LogData=1
Name="TrialProc"
TypeName="Procedure"
Tag=""
Notes=""

[Object7]
_Version=131072
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
_VersionPersist=1
Code="Dim nWidth as long, nHeight as long\nDim cnvs As Canvas\t\t\t\t\t' canvas object to draw on\nDim nLineDist as long\nDim nWordDist as long\nDim paneLeft as long\nDim paneRight as long\nDim paneTop as long\nDim paneBottom as long\ndim i as integer\ndim strText as string\ndim strValue as string\n\n\nSet cnvs = Display.Canvas\t\t\t' initialize canvas object\n\nbAbort = false\niPrevWindow = 0\n\n\nbRefreshAll = true\ncnvs.FontName = \"Courier New\"\n\nstrValue = c.GetAttrib(\"XColor\")\nif Len(strValue)=0 or Left$(strValue,1)=\"?\" then strValue = \"silver\"\nxColor = strValue\n\nstrValue = c.GetAttrib(\"TextColor\")\nif Len(strValue)=0 or Left$(strValue,1)=\"?\" then strValue = \"black\"\ntxtColor = strValue\n\nstrValue = c.GetAttrib(\"FontSize\")\nif Len(strValue)=0 or Left$(strValue,1)=\"?\" then strValue = \"16\"\ncnvs.FontSize = strValue\n\nstrValue = c.GetAttrib(\"WindowSize\")\nif Len(strValue)=0 or Left$(strValue,1)=\"?\" then strValue = \"2\"\nnWindowSize = Val(strValue)\n\nstrValue = c.GetAttrib(\"Filename\")\nif Len(strValue)=0 or Left$(strValue,1)=\"?\" then\n'\tMsgBox \"No text file available!\"\n\tErr.Raise 1,,\"Er is geen tekstfile gespecificeerd!\"\nend if\nif not FileExists(strValue) then\n\tErr.Raise 1,,\"File bestaat niet: \" & strValue\nend if\n\npaneLeft = Display.XRes \\ 10\npaneRight = Display.XRes - paneLeft\npaneTop = Display.YRes \\ 10\npaneBottom = Display.YRes - paneTop\n\n' load text file\ndim pos1 as integer\ndim pos2 as integer\nnWords = 0\n' open input file\nOpen strValue for Input Access read Lock write as #1\n' lees tekst regel voor regel\ndo while not EOF(1)\n\tLine Input #1, strText\n\tstrText = trim(strText)\n\tif Len(strText)=0 then\n\t\t' empty line is new line\n\t\tnWords = nWords + 1\n\t\twords(nWords) = \"\"\n'\t\tprint #2, \"iWord = \" & nWords & \"<empty line>\"\n\telse\n\t\t' split tekst into words (tokens)\n\t\tpos1 = 1\n\t\tdo while pos1>0 \n\t\t\tpos2 = Instr(pos1,strText,\" \")\n\t\t\tif pos2>pos1 then\n\t\t\t\tnWords = nWords + 1\n\t\t\t\twords(nWords) = Mid$(strText, pos1, pos2-pos1)\n'\t\t\t\tprint #2, \"iWord = \" & nWords & words(nWords)\n\t\t\t\tpos1 = pos2+1\n\t\t\telse\n\t\t\t\tif pos1<Len(strText) then\n\t\t\t\t\tnWords = nWords + 1\n\t\t\t\t\twords(nWords) = Mid$(strText, pos1)\n'\t\t\t\t\tprint #2, \"iWord = \" & nWords & words(nWords) & \"  end of string\"\n\t\t\t\tend if\n\t\t\t\tpos1 = 0 ' abort (end of string)\n\t\t\tend if\n\t\tloop\n\tend if\nloop\nClose #1\n\n' create output file\nstrValue = CStr(c.GetAttrib(\"Experiment\")) & \"-\" & CStr(c.GetAttrib(\"Subject\")) & \"-\" & CStr(c.GetAttrib(\"Session\")) & \".dat\"\nOpen strValue for Output Access write Lock read write as #2\n\n\n' collect the words for all windows\ndim nWordsInWindow as integer\nnWindows = 1\nnWordsInWindow = 0\nif nWindowSize>=1 then\n\tfor i=1 to nWords\n\t\tdim strWord as string\n\t\tstrWord = words(i)\n\t\tif Len(strWord)=0 then\n\t\t\t' empty word == new line\n\t\t\tif nWordsInWindow > 0 then\n\t\t\t\tnWordsInWindow = 0\n\t\t\t\tnWindows = nWindows + 1\n\t\t\tend if\n\t\t\tnWindows = nWindows + 1\n\t\t\twindows(nWindows).txt = \"\"\n\t\telse\n'\t\t\tif ((i-1) mod nWindowSize)=0 then\n\t\t\tif nWordsInWindow >= nWindowSize then\n\t\t\t\t' eerst woord van een nieuw cluster\n\t\t\t\tnWordsInWindow = 1\n\t\t\t\tnWindows = nWindows + 1\n\t\t\t\twindows(nWindows).txt = strWord\n\t\t\telse\n\t\t\t\t' add word to current cluster\n'\t\t\t\tdim t as integer\n'\t\t\t\tt = (i-1)\\nWindowSize + 1 ' NB integer division\n\t\t\t\tif nWordsInWindow > 0 then\n\t\t\t\t\tstrWord = \" \" & strWord ' a space between words\n\t\t\t\tend if\n\t\t\t\tnWordsInWindow = nWordsInWindow + 1\n\t\t\t\twindows(nWindows).txt = windows(nWindows).txt & strWord\n\t\t\tend if\n'\t\t\tprint #2, \"iWord = \" & i & \" nWindows = \" & nWindows & \" nWordsInWindow = \" & nWordsInWindow\n\t\tend if\n\tnext\nelse\n\tnWindows = nWords\nend if\n\n' determine maximum character height\ncnvs.CalculateTextSize \"hjHp\", nWidth, nLineDist\n' determine letter width\ncnvs.CalculateTextSize \"X\", nWordDist, nHeight\n\n' determine all text positions and page naumbers for each word cluster\ndim iCurrentLine as integer\niCurrentLine = 1\niCurrentPage = 1\npos1 = paneLeft\npos2 = paneTop\nfor i=1 to nWindows\n\tdim bNewLine as boolean\n\tbNewLine = false\n\n\n\tif Len(windows(i).txt)=0 then\n\t\tbNewLine = true\n\t\tnWidth = 0\n\telse\n\t\tcnvs.CalculateTextSize windows(i).txt, nWidth, nHeight\n\t\tif pos1+nWidth+nWordDist > paneRight then\n\t\t\tbNewLine = true\n\t\tend if\n\tend if\n\tif bNewLine then\n\t\tiCurrentLine = iCurrentLine + 1\n\t\tpos1 = paneLeft\n\t\tpos2 = pos2 + nLineDist\n\t\tif pos2>PaneBottom then\n\t\t\tiCurrentPage = iCurrentPage + 1\n'\t\t\tiCurrentLine = 1 just continue counting... \n\t\t\tpos2 = paneTop\n\t\tend if\n\tend if\n\twindows(i).x = pos1\n\twindows(i).y = pos2\n\twindows(i).w = nWidth\n\twindows(i).linenr = iCurrentLine\n\twindows(i).page = iCurrentPage\n\tif nWidth>0 then pos1 = pos1 + nWidth + nWordDist\n\n'\tprint #2, \"i = \" & i & \" text = '\" & windows(i).txt & \"' pos = \" & windows(i).x &\", \" & windows(i).y\nnext\n\n' remove all empty clusters (used to force empty line)\nfor i=nWindows to 1 step -1\n\tif Len(windows(i).txt)=0 then\n\t\tdim j as integer\n\t\tfor j=i to nWindows-1\n\t\t\twindows(j) = windows(j+1)\n\t\tnext\n\t\tnWindows = nWindows - 1\n\tend if\nnext\n\niCurrentWindow = 1\niCurrentPage = 1\n"
Name="InitExp"
TypeName="InLine"
Tag=""
Notes=""

[Object8]
_Version=65536
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
_ItemList="SelectTextFile;Intro;BlockList;Goodbey"
_VersionPersist=1
FlowLines(0).Count=4
FlowLines(0).FlowItem(0).Name="SelectTextFile"
FlowLines(0).FlowItem(1).Name="Intro"
FlowLines(0).FlowItem(2).Name="BlockList"
FlowLines(0).FlowItem(3).Name="Goodbey"
LogData=0
Name="RootProc"
TypeName="Procedure"
Tag=""
Notes=""

[Object9]
_Version=131072
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
_VersionPersist=1
Code="\nclose #2"
Name="CloseExp"
TypeName="InLine"
Tag=""
Notes=""

[Object10]
_Version=131072
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
_VersionPersist=1
Code="\t\n\tIf bAbort Then\n\t\tDim theList As List\n\t\tSet theList = CList(Rte.GetObject(c.GetAttrib(\"Running\")))\n\t\tIf Not theList Is Nothing Then\n\t\t\ttheList.Terminate\n\t\tEnd If\n\tEnd If\n"
Name="CheckAbort"
TypeName="InLine"
Tag=""
Notes=""

[Object11]
_Version=65536
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
Logging("OnsetDelay").Log=0
Logging("OnsetTime").Log=0
Logging("DurationError").Log=0
Logging("PreRelease").Log=0
Logging("Duration").Log=0
Logging("StartTime").Log=0
Logging("OffsetTime").Log=0
Logging("FinishTime").Log=0
Logging("TimingMode").Log=0
Logging("CustomOnsetTime").Log=0
Logging("CustomOffsetTime").Log=0
Logging("ActionDelay").Log=0
Logging("ActionTime").Log=0
Logging("TargetOffsetTime").Log=0
Logging("TargetOnsetTime").Log=0
Logging("OffsetDelay").Log=0
Logging("RTTime").Log=0
Logging("ACC").Log=0
Logging("RT").Log=0
Logging("RESP").Log=0
Logging("CRESP").Log=0
Logging("Tag").Log=0
Input(0)=!Data1
_VersionPersist=1
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
Text="\nTexfile: [Filename]\nWindow Size: [WindowSize]\n\n\n\n\npress enter to start the test"
ForeColor="black"
BackColor="white"
BackStyle="opaque"
BorderColor="black"
BorderWidth="0"
X="center"
Y="center"
Width="100%"
Height="100%"
XAlign="center"
YAlign="center"
AlignHorizontal="center"
AlignVertical="center"
FontName="Courier New"
FontSize="18"
FontBold="Yes"
FontItalic="No"
FontUnderline="No"
FontStrikeout="No"
WordWrap=1
ClearAfter="Yes"
Duration="-1"
JumpLabel=""
TimingMode=0
PreRelease="0"
OnsetSync=1
OffsetSync=0
Name="StartSession"
TypeName="TextDisplay"
Tag=""
Notes=""

[Data1]
DeviceName="Keyboard"
DeviceClass="Keyboard"
AllowableInput="{ENTER}"
CorrectInput=""
TimeLimit=""
MaxCount="1"
InputAction=1
SyncOwnerDuration=1
Enabled=1
FlushInputBuffer="Yes"
TerminationInput=""
UserTag=""
ResponseMode="All"
ProcessBackspace="Yes"

[Object12]
_Version=65536
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
Logging("OnsetDelay").Log=0
Logging("OnsetTime").Log=0
Logging("DurationError").Log=0
Logging("PreRelease").Log=0
Logging("Duration").Log=0
Logging("StartTime").Log=0
Logging("OffsetTime").Log=0
Logging("FinishTime").Log=0
Logging("TimingMode").Log=0
Logging("CustomOnsetTime").Log=0
Logging("CustomOffsetTime").Log=0
Logging("ActionDelay").Log=0
Logging("ActionTime").Log=0
Logging("TargetOffsetTime").Log=0
Logging("TargetOnsetTime").Log=0
Logging("OffsetDelay").Log=0
Logging("RTTime").Log=0
Logging("ACC").Log=0
Logging("RT").Log=0
Logging("RESP").Log=0
Logging("CRESP").Log=0
Logging("Tag").Log=0
_VersionPersist=2
ActiveState="Default"
States.Count=1
States(1).Name="Default"
States("Default").X="center"
States("Default").Y="center"
States("Default").Width="100%"
States("Default").Height="100%"
States("Default").XAlign="center"
States("Default").YAlign="center"
States("Default").BackColor="white"
States("Default").BackStyle="opaque"
States("Default").BorderColor="black"
States("Default").BorderWidth="0"
States("Default").ClearAfter="No"
States("Default").Enabled="Yes"
States("Default").ChildCount=2
States("Default").Objects(1).Type="Text"
States("Default").Objects(1).Text="Vrije Universiteit\r\nFac. Psychologie en Pedagogiek\r\nProgramming by Paul Groot - ITM"
States("Default").Objects(1).Width="100%"
States("Default").Objects(1).Height="25%"
States("Default").Objects(1).X="center"
States("Default").Objects(1).Y="399"
States("Default").Objects(1).AlignHorizontal="center"
States("Default").Objects(1).AlignVertical="center"
States("Default").Objects(1).FontName="Arial"
States("Default").Objects(1).FontSize="16"
States("Default").Objects(1).FontBold="No"
States("Default").Objects(1).FontUnderline="No"
States("Default").Objects(1).FontStrikeout="No"
States("Default").Objects(1).FontItalic="No"
States("Default").Objects(1).ForeColor="black"
States("Default").Objects(1).BackColor="white"
States("Default").Objects(1).BackStyle="opaque"
States("Default").Objects(1).BorderWidth="0"
States("Default").Objects(1).BorderColor="black"
States("Default").Objects(1).XAlign="center"
States("Default").Objects(1).YAlign="center"
States("Default").Objects(1).WordWrap=1
States("Default").Objects(1).Name="Text1"
States("Default").Objects(2).Type="Text"
States("Default").Objects(2).Text="MaskedReading test"
States("Default").Objects(2).Width="100%"
States("Default").Objects(2).Height="25%"
States("Default").Objects(2).X="center"
States("Default").Objects(2).Y="147"
States("Default").Objects(2).AlignHorizontal="center"
States("Default").Objects(2).AlignVertical="center"
States("Default").Objects(2).FontName="Arial"
States("Default").Objects(2).FontSize="28"
States("Default").Objects(2).FontBold="Yes"
States("Default").Objects(2).FontUnderline="No"
States("Default").Objects(2).FontStrikeout="No"
States("Default").Objects(2).FontItalic="No"
States("Default").Objects(2).ForeColor="black"
States("Default").Objects(2).BackColor="white"
States("Default").Objects(2).BackStyle="opaque"
States("Default").Objects(2).BorderWidth="0"
States("Default").Objects(2).BorderColor="black"
States("Default").Objects(2).XAlign="center"
States("Default").Objects(2).YAlign="center"
States("Default").Objects(2).WordWrap=1
States("Default").Objects(2).Name="Text2"
Duration="2000"
JumpLabel=""
TimingMode=0
PreRelease="0"
OnsetSync=1
OffsetSync=0
Name="Intro"
TypeName="Slide"
Tag=""
Notes=""

[Object13]
_Version=65536
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
Logging("OnsetDelay").Log=0
Logging("OnsetTime").Log=0
Logging("DurationError").Log=0
Logging("PreRelease").Log=0
Logging("Duration").Log=0
Logging("StartTime").Log=0
Logging("OffsetTime").Log=0
Logging("FinishTime").Log=0
Logging("TimingMode").Log=0
Logging("CustomOnsetTime").Log=0
Logging("CustomOffsetTime").Log=0
Logging("ActionDelay").Log=0
Logging("ActionTime").Log=0
Logging("TargetOffsetTime").Log=0
Logging("TargetOnsetTime").Log=0
Logging("OffsetDelay").Log=0
Logging("RTTime").Log=0
Logging("ACC").Log=0
Logging("RT").Log=0
Logging("RESP").Log=0
Logging("CRESP").Log=0
Logging("Tag").Log=0
_VersionPersist=1
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
Text="end of this test"
ForeColor="black"
BackColor="white"
BackStyle="opaque"
BorderColor="black"
BorderWidth="0"
X="center"
Y="center"
Width="100%"
Height="100%"
XAlign="center"
YAlign="center"
AlignHorizontal="center"
AlignVertical="center"
FontName="Courier New"
FontSize="18"
FontBold="Yes"
FontItalic="No"
FontUnderline="No"
FontStrikeout="No"
WordWrap=1
ClearAfter="No"
Duration="3000"
JumpLabel=""
TimingMode=0
PreRelease="0"
OnsetSync=1
OffsetSync=0
Name="Goodbey"
TypeName="TextDisplay"
Tag=""
Notes=""

[Object14]
_Version=131072
_ExtentX=2646
_ExtentY=1323
_StockProps=0
VersionMajor=1
VersionMinor=2
VersionInternal=1
VersionBuild=52
_VersionPersist=1
Code="\n'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\n' Try to locate an external text file (*.txt)\n' Show a selection dialog when more parms-files exist.\nDim strFiles(32)\nDim vAnswer As Variant\nDim nFiles as integer\nstrFiles(0) = Dir$(\"*.txt\")\nWhile (strFiles(nFiles)<>\"\" And nFiles<UBound(strFiles))\n\tnFiles = nFiles + 1\n\tstrFiles(nFiles) = Dir$\nWend\nif nFiles>1 then\n\tMouse.ShowCursor True\n\tvAnswer = SelectBox(, \"Select text file\", strFiles)\nelseif nFiles=1 then\n\tvAnswer = 0 ' just use the only file found\nelse\n\tvAnswer = -1\nend if\nIf vAnswer >= 0 then\n\tc.SetAttrib \"Filename\", strFiles(vAnswer)\nelse\n\tExit Sub\nEnd If\n\n"
Name="SelectTextFile"
TypeName="InLine"
Tag=""
Notes=""

[UserScript]
type Window
	x as Long
	y as Long
	w as long ' text width
	page as integer
	linenr as integer
	txt as string
end type

dim iCurrentPage as integer
dim iCurrentWindow as integer
dim iPrevWindow as integer ' index of previous window (index for windows())

dim words(1 to 4000) as string
dim nWords as integer
dim nWindowSize as integer ' #words in readable window
dim windows(1 to 4000) as Window
dim nWindows as integer
dim bRefreshAll as boolean
dim xColor as string
dim txtColor as string
dim bAbort as boolean
dim iBrowseAnchorX as long ' x-coordinate of text when starting up or down browsing

